import java.io.*;
import java.util.*;
import java.text.*;

import java.io.IOException;
import java.io.OutputStream;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionException;
import com.sap.conn.jco.ext.SessionReferenceProvider;

/**
 * basic examples for Java to ABAP communication  
 */
public class ScheduleJob
{
    static String FINISHED = "F";
    static String STARTED = "S";
    static String ABORT = "A";
    static String READY = "R";
    static String CONNECTION = "SAP_CONNECTION";
    static String REQUIRED = "... this parameter is required, can not continue, call without parameters for HELP ...";

	public static Properties CreateDestination (Properties argsProperties) 
    {
  
        Properties connectProperties = new Properties();
    	connectProperties.setProperty(DestinationDataProvider.JCO_ASHOST, argsProperties.getProperty("ASHOST"));
     	connectProperties.setProperty(DestinationDataProvider.JCO_SYSNR,  argsProperties.getProperty("SYSNR"));
        connectProperties.setProperty(DestinationDataProvider.JCO_CLIENT, argsProperties.getProperty("CLIENT"));
        connectProperties.setProperty(DestinationDataProvider.JCO_USER,   argsProperties.getProperty("USER"));
        connectProperties.setProperty(DestinationDataProvider.JCO_PASSWD, argsProperties.getProperty("PASSWD"));
        connectProperties.setProperty(DestinationDataProvider.JCO_LANG,   argsProperties.getProperty("LANGUAGE"));
        //connectProperties.setProperty(DestinationDataProvider.JCO_POOL_CAPACITY, "3");
        //connectProperties.setProperty(DestinationDataProvider.JCO_PEAK_LIMIT,    "10");
         
        return connectProperties;
    }
    
     /**
     * @throws JCoException
     */
    public static Object[] ConnectUsingPool(String DESTINATION, Properties connectProperties) throws JCoException
    {
    
    	int RC = 8;
    	
		ownDestinationDataProvider provider = new ownDestinationDataProvider();
		provider.addDestination( DESTINATION, connectProperties );
		com.sap.conn.jco.ext.Environment.registerDestinationDataProvider( provider );

 		JCoDestination destination = JCoDestinationManager.getDestination(DESTINATION);
        
        destination.ping();
        System.out.println("Attributes:");
        System.out.println(destination.getAttributes());
        System.out.println();
        
        if ( destination.isValid() ) 
        	RC = 0;
        
        Object[] result = new Object[] {  RC, destination };
        
        return result;
    }
    
     /**
     * The following example executes a simple RFC function STFC_CONNECTION.
     * @throws JCoException
     */
    public static int CheckConnection(JCoDestination destination) throws JCoException
    {
        JCoFunction function = destination.getRepository().getFunction("STFC_CONNECTION");
        if(function == null)
            throw new RuntimeException("BAPI_COMPANYCODE_GETLIST not found in SAP.");

		String ReqText = "Okay";
		int result = 8;

        //JCoFunction is container for function values. Each function contains separate
        //containers for import, export, changing and table parameters.
        //To set or get the parameters use the APIS setValue() and getXXX(). 
        function.getImportParameterList().setValue("REQUTEXT", ReqText);
        
        try
        {
            function.execute(destination);
        }
        catch(AbapException e)
        {
            System.out.println(e.toString());
            return result;
        }
        
        String EchoText = function.getExportParameterList().getString("ECHOTEXT");
        String RespText = function.getExportParameterList().getString("RESPTEXT");
        
        System.out.println("STFC_CONNECTION finished:");
        System.out.println(" Echo: " + EchoText);
        System.out.println(" Response: " + RespText);
        System.out.println();
        
        if ( EchoText ==  ReqText ) 
        	result = 0;
        	
        return result;
    }
    
     /* Plan Job and schedule it
     * @throws JCoException
     */
     
     
    public static Object[] SUBST_START_BATCHJOB(JCoDestination destination, Properties argsProperties ) throws JCoException
    {

        JCoFunction function = destination.getRepository().getFunction("SUBST_START_BATCHJOB");
        if (function == null)
            throw new RuntimeException("Unable to start function:SUBST_START_BATCHJOB");

        //JCoFunction is container for function values. Each function contains separate
        //containers for import, export, changing and table parameters.
        //To set or get the parameters use the APIS setValue() and getXXX(). 
        
        function.getImportParameterList().setValue("JOBNAME", argsProperties.getProperty("JOBNAME"));
        function.getImportParameterList().setValue("REPNAME", argsProperties.getProperty("REPNAME"));
        function.getImportParameterList().setValue("VARNAME", argsProperties.getProperty("VARNAME"));
        function.getImportParameterList().setValue("AUTHCKNAM", argsProperties.getProperty("AUTHCKNAM"));
        function.getImportParameterList().setValue("BATCHHOST", argsProperties.getProperty("BATCHHOST"));
        function.getImportParameterList().setValue("LANGUAGE", argsProperties.getProperty("LANGUAGE"));
        function.getImportParameterList().setValue("PRIPARAMS",argsProperties.getProperty("PRIPARAMS"));
        function.getImportParameterList().setValue("IV_SCHEDEVER", argsProperties.getProperty("IV_SCHEDEVER"));
        function.getImportParameterList().setValue("IV_ABORT_ON_ERROR", argsProperties.getProperty("IV_ABORT_ON_ERROR"));
        function.getImportParameterList().setValue("BATCHINSTANCE", argsProperties.getProperty("BATCHINSTANCE"));
        
        int RC = 8;
        Object[] result = new Object[] {  RC,  null,  null };
        
        try
        {
            function.execute(destination);
        }
        catch(AbapException e)
        {
            System.out.println(e.toString());
            return result;
        }
        
        String JobCount = function.getExportParameterList().getString("JOBCOUNT");
        String RC_Start = function.getExportParameterList().getString("RC_START");
		
		if ( Integer.parseInt(RC_Start)  == 0 )
			RC = 0;
		else
			RC = 8;
			
        result  = new Object[] {  RC, JobCount , RC_Start };
        
        System.out.println("SUBST_START_BATCHJOB finished:");
        System.out.println(" JobCount: " + JobCount);
        System.out.println(" RC_Start: " + RC_Start);
        System.out.println(" RC: " + RC );
        System.out.println();
        
        return result;
    }
    
      /* Monitor Job 
     * @throws JCoException
     */
    public static Object[] SUBST_CHECK_BATCHJOB (JCoDestination destination, String JobName, String JobCount, boolean print) throws JCoException
    {
        JCoFunction function = destination.getRepository().getFunction("SUBST_CHECK_BATCHJOB");
        if(function == null)
            throw new RuntimeException("Unable to start function:SUBST_CHECK_BATCHJOB");
     
        function.getImportParameterList().setValue("JOBNAME", JobName);
        function.getImportParameterList().setValue("JOBCOUNT", JobCount);
        function.getImportParameterList().setValue("IV_VERIFY", "X");
        
        int RC = 8;
        Object[] result = new Object[] {  RC,  null,  null, null, null };
        
        try
        {
             function.execute(destination);
        }
        catch(AbapException e)
        {
            System.out.println(e.toString());
            return result;
        }
        
        String RC_Check = function.getExportParameterList().getString("RC_CHECK");
        String JobStatus = function.getExportParameterList().getString("JOBSTATUS");
		//String JobEndDate = function.getExportParameterList().getString("JOBENDDATE");
		//String JobEndTime = function.getExportParameterList().getString("JOBENDTIME");
        
        if ( Integer.parseInt(RC_Check)  == 0 )
			RC = 0;
		else
			RC = 8;
        
        result = new Object[] {  RC,  RC_Check,  JobStatus };
        
        if (( print ) || ( JobStatus.equals(STARTED) ))
        {
        	System.out.println("SUBST_CHECK_BATCHJOB finished:");
        	System.out.println(" JobName: " + JobName);
        	System.out.println(" JobCount: " + JobCount);
        	System.out.println(" JobStatus: " + JobStatus);
        	System.out.println(" RC_Check: " + RC_Check);
        	System.out.println(" RC: " + RC);
	       	//System.out.println(" JobEndDate: " + JobEndDate);
        	//System.out.println(" JobEndTime: " + JobEndTime);
       	 	System.out.println();
       	 }
        
        return result;
    }
  
          /* Monitor Job 
     * @throws JCoException
     */
    public static Object[] Z_SUBST_LIST_JOBLOG (JCoDestination destination, String JobName, String JobCount) throws JCoException
    {
        JCoFunction function = destination.getRepository().getFunction("Z_SUBST_LIST_JOBLOG");
        if(function == null)
            throw new RuntimeException("Unable to start function:Z_SUBST_LIST_JOBLOG");
                
        function.getImportParameterList().setValue("JOBNAME", JobName);
        function.getImportParameterList().setValue("JOBCOUNT", JobCount);
        
        int RC = 8;
        Object[] result = new Object[] {  RC, null };
        
        try
        {
			function.execute(destination);
        }
        catch (AbapException e)
        {
            System.out.println(e.toString());
            return result;
        }
        
       	String Return = function.getExportParameterList().getString("RETURN");
       	
        if ( Return.length() == 0 ) 
        	RC = 0;
        else 
        	if ( Integer.parseInt(Return) == 0 )
        	 	RC = 0;
        	else 
        		RC = 4;
        
        if ( RC == 0 )  
        {
        	System.out.println("JOBLST --- JOBLST --- JOBLST --- JOBLST --- JOBLST --- JOBLST"); 
       		JCoTable jobout = function.getTableParameterList().getTable("JOBLOG_TAB");
        	for (int i = 0; i < jobout.getNumRows(); i++) 
        	{
            	jobout.setRow(i);
            	System.out.println( jobout.getString("ENTERDATE") + "  " +
            						jobout.getString("ENTERTIME") + "  " + 
            						jobout.getString("MSGID") + 
            						jobout.getString("MSGNO") + 
            						jobout.getString("MSGTYPE") + "   " +
            						jobout.getString("TEXT") );
        	}

			System.out.println("JOBLST --- JOBLST --- JOBLST --- JOBLST --- JOBLST --- JOBLST");
        	System.out.println();
        }
                        
        result = new Object[] {  RC,  null };
        
        System.out.println("Z_SUBST_LIST_JOBLOG finished:");
        System.out.println(" JobName: " + JobName);
        System.out.println(" JobCount: " + JobCount);
        System.out.println(" RC: " + RC );
        System.out.println();
        
        return result;
    }

	public static void help ()
	{
	
		System.out.println();
		System.out.println("Help --- Help --- Help --- Help --- Help --- Help --- Help");
		System.out.println("Required parameters:");
		System.out.println("         JOBNAME=<jobname>");
		System.out.println("         REPNAME=<report name>");
		System.out.println("         VARNAME=<variante>");
		System.out.println("         ASHOST=<Application Server>");
		System.out.println("         SYSNR=<SAPSYSTEM NR>");
		System.out.println("         USER=<SAP User>");
		System.out.println("         PASSWD=<SAP User Password>");
		System.out.println("Optional parameters:");
		System.out.println("         AUTHCKNAM=<SAP Batch User>");
		System.out.println("         BATCHHOST=<SAP Batch Host>");
		System.out.println("         LANGUAGE=<language for Job>");
		System.out.println("         CLIENT=<SAP Client/Mandt>");
		System.out.println("         TIMOUT=<max wait time in seconds> (integer)");	
		System.out.println("         INTERVAL=<interval to rekick status check> (integer)");
		System.out.println("Refer to Function:SUBST_START_BATCHJOB to get the compete list of options");
		System.out.println("Help --- Help --- Help --- Help --- Help --- Help --- Help");
		System.out.println();
		
		}
		
	public static void printARGS (Properties argsProperties) 	
	{
		System.out.println();
		System.out.println("Arguments in effect --- Arguments in effect --- Arguments in effect");
		System.out.println("JOBNAME:" + argsProperties.getProperty("JOBNAME"));
		if ( argsProperties.getProperty("JOBNAME").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}
        System.out.println("REPNAME:" + argsProperties.getProperty("REPNAME"));
        if ( argsProperties.getProperty("REPNAME").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}
        System.out.println("VARNAME:" + argsProperties.getProperty("VARNAME"));
        System.out.println("AUTHCKNAM:" + argsProperties.getProperty("AUTHCKNAM"));
        System.out.println("BATCHHOST:" + argsProperties.getProperty("BATCHHOST"));
        System.out.println("LANGUAGE:" + argsProperties.getProperty("LANGUAGE"));
        System.out.println("PRIPARAMS:" + argsProperties.getProperty("PRIPARAMS"));
        System.out.println("IV_SCHEDEVER:" + argsProperties.getProperty("IV_SCHEDEVER"));
        System.out.println("IV_ABORT_ON_ERROR:" + argsProperties.getProperty("IV_ABORT_ON_ERROR"));
        System.out.println("BATCHINSTANCE:" + argsProperties.getProperty("BATCHINSTANCE"));
        System.out.println("TIMEOUT:" + argsProperties.getProperty("TIMEOUT"));
        System.out.println("INTERVAL:" + argsProperties.getProperty("INTERVAL"));
        System.out.println("JOBLST:" + argsProperties.getProperty("JOBLST"));
        System.out.println("ASHOST:" + argsProperties.getProperty("ASHOST"));
        if ( argsProperties.getProperty("ASHOST").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}
        System.out.println("SYSNR:" + argsProperties.getProperty("SYSNR"));
        if ( argsProperties.getProperty("SYSNR").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}
 
        System.out.println("CLIENT:" + argsProperties.getProperty("CLIENT"));
        if ( argsProperties.getProperty("CLIENT").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}
        System.out.println("USER:" + argsProperties.getProperty("USER"));
        if ( argsProperties.getProperty("USER").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}
		String password = "---MISSING---";
		if ( argsProperties.getProperty("PASSWD").length() > 0 ) 
			password = "---ENTERED---";
		System.out.println("PASSWD:" + password);
        if ( argsProperties.getProperty("PASSWD").length() == 0 ) {
			throw new IllegalArgumentException(REQUIRED);
		}

		System.out.println("Arguments in effect --- Arguments in effect --- Arguments in effect");
		System.out.println();
	}

    public static Properties parseARGS (String[] args) 
    {
    
    	if ( args.length == 0 ) {
    		help();
			System.exit(100);
    	}
    	
    	Properties argsProperties = new Properties();
    
    	String JOBNAME = "";
		String REPNAME = "";
		String VARNAME = "";
		String AUTHCKNAM = "";
		String BATCHHOST = "";
		String LANGUAGE = "EN";
		String PRIPARAMS = "";
		String IV_SCHEDEVER = "";
		String IV_ABORT_ON_ERROR = "X";
		String BATCHINSTANCE = "";
		String TIMEOUT = "86400";
		String INTERVAL = "30";
		
		String ASHOST = "";
		String SYSNR = "";
		String CLIENT = "";
		String USER = ""; 
		String PASSWD = "";
		String JOBLST = "";
		        
        argsProperties.setProperty("JOBNAME",JOBNAME);
        argsProperties.setProperty("REPNAME",REPNAME);
        argsProperties.setProperty("VARNAME",VARNAME);
        argsProperties.setProperty("AUTHCKNAM",AUTHCKNAM);
        argsProperties.setProperty("BATCHHOST",BATCHHOST);
        argsProperties.setProperty("LANGUAGE",LANGUAGE);
        argsProperties.setProperty("PRIPARAMS",PRIPARAMS);
        argsProperties.setProperty("IV_SCHEDEVER",IV_SCHEDEVER);
        argsProperties.setProperty("IV_ABORT_ON_ERROR",IV_ABORT_ON_ERROR);
        argsProperties.setProperty("BATCHINSTANCE",BATCHINSTANCE);
        argsProperties.setProperty("TIMEOUT",TIMEOUT);
        argsProperties.setProperty("ASHOST",ASHOST);
        argsProperties.setProperty("SYSNR",SYSNR);
        argsProperties.setProperty("CLIENT",CLIENT);
        argsProperties.setProperty("USER",USER);
        argsProperties.setProperty("PASSWD",PASSWD);
        argsProperties.setProperty("JOBLST",JOBLST);
        argsProperties.setProperty("INTERVAL",INTERVAL);
		
        System.out.println("Arguments entered --- Arguments entered --- Arguments entered");
        
        String keyword = null;
        String value = null;
                       
        for (String s: args) {
        	try 
        	{
         		String[] parts = s.split("=");
         		keyword = parts[0];
            	value =  parts[1];
            	
            	if ( ! keyword.equals("PASSWD") )
            	{
            		System.out.println(keyword + "=" + value);
            	}
            	else 
            	{
            		System.out.println(keyword + "=" + "---ENTERED---");
            	}
            	
         	}
         	catch(ArrayIndexOutOfBoundsException e)
         	{
         		System.out.println("Argument: Keyword:" + s + " is not supported");
         		System.exit(16);
         	}
       	
        switch (keyword) {
         		case "JOBNAME": 
         		 	argsProperties.setProperty("JOBNAME",value);
         		 	break;
         		case "REPNAME": 
         		 	argsProperties.setProperty("REPNAME",value);
         		 	break;
         		case "VARNAME": 
         		 	argsProperties.setProperty("VARNAME",value);
         		 	break;
         		case "AUTHCKNAM": 
         		 	argsProperties.setProperty("AUTHCKNAM",value);
         		 	break;
         		case "BATCHHOST": 
         		 	argsProperties.setProperty("BATCHHOST",value);
         		 	break;
         		case "LANGUAGE": 
         		 	argsProperties.setProperty("LANGUAGE",value);
         		 	break;
         		case "PRIPARAMS": 
         		 	argsProperties.setProperty("PRIPARAMS",value);
         		 	break;
         		case "IV_SCHEDEVER": 
         		 	argsProperties.setProperty("IV_SCHEDEVER",value);
         		 	break;
         		case "IV_ABORT_ON_ERROR": 
         		 	argsProperties.setProperty("IV_ABORT_ON_ERROR",value);
         		 	break;
         		case "BATCHINSTANCE": 
         		 	argsProperties.setProperty("BATCHINSTANCE",value);
         		 	break;
         		case "TIMEOUT": 
         		 	argsProperties.setProperty("TIMEOUT",value);
         		 	break;
         		case "ASHOST": 
         		 	argsProperties.setProperty("ASHOST",value);
         		 	break;
         		case "SYSNR": 
         		 	argsProperties.setProperty("SYSNR",value);
         		 	break;
         		case "CLIENT": 
         		 	argsProperties.setProperty("CLIENT",value);
         		 	break;
         		case "USER": 
         		 	argsProperties.setProperty("USER",value);
         		 	break;
         		case "PASSWD": 
         		 	argsProperties.setProperty("PASSWD",value);
         		 	break;
         		case "JOBLST": 
         		 	argsProperties.setProperty("JOBLST",value);
         		 	break;
         		case "INTERVAL": 
         		 	argsProperties.setProperty("INTERVAL",value);
         		 	break;

         		default:
         			System.out.println("Argument: Keyword:" + s + " not supported");
         			System.exit(16);
         			break;
         	} 	
        }
        
    	System.out.println("Arguments entered --- Arguments entered --- Arguments entered");        
        System.out.println();

        return argsProperties;
    }

    public static void main(String[] args) throws JCoException , InterruptedException, ArrayIndexOutOfBoundsException
    {
    
    	System.out.println("ScheduleJob                Schedule a SAP Job");
		System.out.println("                           by Henri.Hoffmann(at)SysConsult.de");
		System.out.println("                           Version 0.5");
		System.out.println();
    
		int ReturnCode = 16;
		int RC = 0;
		Object[] JobReturn = null;

		Properties argsProperties = parseARGS(args);
	 	printARGS(argsProperties);
		
        Properties connectProperties = CreateDestination(argsProperties);
       
        JobReturn = ConnectUsingPool(CONNECTION,connectProperties);
        ReturnCode = (int) JobReturn[0];
        JCoDestination destination = (JCoDestination) JobReturn[1];
        
        System.out.println();
        
        ReturnCode = CheckConnection(destination);
        
        System.out.println();
        
        JobReturn = SUBST_START_BATCHJOB( destination, argsProperties);
        
    	ReturnCode = (int) JobReturn[0];
    	String JobCount = (String) JobReturn[1];
    	String RC_Start = (String) JobReturn[2];
    
    	int loops =  Integer.parseInt(argsProperties.getProperty("TIMEOUT")) / Integer.parseInt(argsProperties.getProperty("INTERVAL"));
    	
    	String JobStatus = null;
    	Object[] CheckReturn = null;
    	String RC_CHECK = null; 
    	boolean print = false;
    	
    	int i = 0;
    	while ( i < loops ) {
        	
        	if ( i % 10 == 0 )
        	{
        		print = true;
        		DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
				Calendar cal = Calendar.getInstance();
				System.out.println("... Waiting for Job End, Loop#:" + i + ", TimeStamp:" + dateFormat.format(cal.getTime()));
        	}
        	else
        		print = false;
        		 
        	CheckReturn = SUBST_CHECK_BATCHJOB(destination, argsProperties.getProperty("JOBNAME"), JobCount, print); 
        	RC = (int) JobReturn[0]; 	
        	RC_CHECK = (String) JobReturn[1];
        	JobStatus = (String) CheckReturn[2];
        	 
        	if ( JobStatus.equals(FINISHED) || JobStatus.equals(ABORT) ) 
        	{
        		break;
        	}
        	else
        	{
        		Thread.sleep(Integer.parseInt(argsProperties.getProperty("INTERVAL")) * 1000);
        	}
        	i++;
        }
        
        Object[] JobList = null;

		RC = CheckConnection(destination);

		if (  ! JobStatus.equals(FINISHED) )  {
			ReturnCode = 8;
		}  
		if ( JobStatus.equals(STARTED) )  {
			ReturnCode = 4;
		}     
		
		System.out.println();
		 
        if ( argsProperties.getProperty("JOBLST").length() > 0 )
        {
        	System.out.println("Retrieving Job List Output:");
        	CheckReturn = Z_SUBST_LIST_JOBLOG(destination, argsProperties.getProperty("JOBNAME"), JobCount); 
        	RC = (int) JobReturn[0]; 	
    	}
        
        System.out.println("Finished, Job:" + argsProperties.getProperty("JOBNAME") + ", Report:" + argsProperties.getProperty("REPNAME") + ", Variant:" + argsProperties.getProperty("VARNAME") + ", JobStatus:" + JobStatus + ", Returned RC:" + ReturnCode );
       
        System.exit(ReturnCode);
    }
}