import java.io.*;
import java.util.*;

import com.sap.conn.jco.ext.*;
import com.sap.conn.jco.*; 

public class ownDestinationDataProvider
    implements DestinationDataProvider
{
    Map<String, Properties> propertiesForDestinationName = new HashMap<String, Properties>();

    public void addDestination( String destinationName, Properties properties )
    {
        propertiesForDestinationName.put( destinationName, properties );
    }

    public Properties getDestinationProperties( String destinationName )
    {
        if ( propertiesForDestinationName.containsKey( destinationName ) )
        {
            return propertiesForDestinationName.get( destinationName );
        }
        else
        {
            throw new RuntimeException( "Destination not found: " + destinationName );
        }
    }

    public void setDestinationDataEventListener( DestinationDataEventListener eventListener )
    {
        // nothing to do
    }

    public boolean supportsEvents()
    {
        return false;
    }
}
